% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description.R
\name{description}
\alias{description}
\alias{description<-}
\title{Get or set the dataset Description}
\usage{
description(x)

description(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{\link[=dataset_df]{dataset_df()}} or
\code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{Logical. If \code{TRUE}, will overwrite any existing description.
If \code{FALSE} (default), will warn and keep the existing description.}

\item{value}{The new description, as a character string.}
}
\value{
The \code{Description} attribute as a character vector of length 1.
}
\description{
Get or set the optional \code{Description} property as an attribute
on a dataset object.
}
\details{
The \code{Description} is recommended for discovery in DataCite. It
captures additional information that does not fit other metadata categories
— such as technical notes or dataset usage. It is a free-text field. See
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/description/}{dct:description}.
}
\examples{
description(orange_df)
description(orange_df, overwrite = TRUE) <- "This dataset records orange tree growth."
description(orange_df)

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
