% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_unit.R
\name{var_unit}
\alias{var_unit}
\alias{var_unit<-}
\alias{var_unit<-.default}
\alias{get_variable_units}
\alias{unit_attribute}
\alias{get_unit_attribute}
\alias{set_unit_attribute}
\alias{unit_attribute<-}
\title{Get or Set a Unit of Measure}
\usage{
var_unit(x, ...)

var_unit(x) <- value

\method{var_unit}{default}(x) <- value

get_variable_units(x, ...)

unit_attribute(x)

get_unit_attribute(x)

set_unit_attribute(x, value)

unit_attribute(x) <- value
}
\arguments{
\item{x}{A vector.}

\item{...}{Further arguments for method extensions.}

\item{value}{A single character string or \code{NULL}. If not of length one, an
error is thrown.}
}
\value{
\itemize{
\item \code{var_unit(x)} returns the \code{"unit"} attribute as a character string.
\item \code{var_unit(x) <- value} sets, updates, or removes the unit and returns
the modified vector invisibly.
}

The modified object \code{x}, returned invisibly with the updated \code{"unit"}
attribute.

The \code{"unit"} attribute of the object \code{x}, or \code{NULL} if not set.

The object \code{x} with updated \code{"unit"} attribute.
}
\description{
Adds or retrieves a unit of measure (UoM) attribute to a vector. Units
provide semantic meaning for numeric or character data — such as currency,
weight, or time — helping prevent incorrect operations like merging values
measured in incompatible units.

The \verb{var_unit<-} assignment method sets, updates, or removes the \code{"unit"}
attribute of a vector. This can be used with \code{defined()} vectors or base
vectors to ensure consistent semantic annotation.

\code{unit_attribute()} is a low-level helper to directly access the \code{"unit"}
attribute of a vector, without applying fallback logic. It is mainly used
internally.

\code{get_unit_attribute()} is an alias for \code{unit_attribute()}, included for naming
consistency in codebases that distinguish getter/setter patterns.

\code{set_unit_attribute()} is the low-level assignment function that sets or
removes the \code{"unit"} attribute of an object. Used internally by
\verb{unit_attribute<-}.
}
\details{
The \code{"unit"} attribute stores a machine-readable representation of a
unit of measure (e.g., \code{"kg"}, \code{"USD"}, \code{"days"}). This is useful when
working with linked open data or when combining data from multiple sources
where silent mismatches in units could cause errors.

For full integration with semantic metadata (e.g., labels, concepts,
namespaces), use \code{\link[=defined]{defined()}} vectors or \code{\link[=dataset_df]{dataset_df()}} objects.

\code{get_variable_units()} is an alias for \code{var_unit()}.

See \code{vignette("defined", package = "dataset")} for end-to-end examples
involving semantic enrichment.
}
\examples{
# Retrieve the unit of measure (if defined)
var_unit(orange_df$circumference)

# Regular data.frame columns have no unit by default
var_unit(mtcars$wt)

# Add a unit to a column
var_unit(mtcars$wt) <- "1000 lbs"

# Remove the unit
var_unit(mtcars$wt) <- NULL

}
\seealso{
Other defined metadata methods and functions: 
\code{\link{var_label}()},
\code{\link{var_labels}()},
\code{\link{var_namespace}()}
}
\concept{defined metadata methods and functions}
