% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minMax.R
\name{minMax}
\alias{minMax}
\title{summaryFunction for minimum and maximum}
\usage{
minMax(v, maxDecimals = 2)
}
\arguments{
\item{v}{A variable (vector) of type numeric or integer.}

\item{maxDecimals}{A positive integer or \code{Inf}. Number of decimals used when
printing numerical values in the data summary and in problematic values from the
data checks. If \code{Inf}, no rounding is performed.}
}
\value{
An object of class \code{summaryResult} with the following entries: \code{$feature} 
("Min. and max."), \code{$result} (the minimum and maximum of \code{v}), and \code{$value}
(minimum and maximum in their orignial format).
}
\description{
A \code{summaryFunction}, intended to be called from 
\code{\link{summarize}}, which returns the minimum and maximum values of a variable.
NA, NaN and Inf values are removed prior to the computations.
}
\examples{
minMax(c(1:100))

}
\seealso{
\code{\link{summaryFunction}}, \code{\link{summarize}}, \code{\link{summaryResult}},
\code{\link{allSummaryFunctions}}
}
