% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_value_range_violations.R
\name{detect_value_range_violations}
\alias{detect_value_range_violations}
\title{Detect value range violations}
\usage{
detect_value_range_violations(activitylog, ..., details, filter_condition)
}
\arguments{
\item{activitylog}{The activity log}

\item{...}{Define domain range using domain_numeric, domain_categorical and/or domain_time for each column}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
activitylog containing the rows of the original activity log for which the provided value range is violated
}
\description{
Function detecting violations of the value range, i.e. values outside the range of tolerable values
}
\examples{
\donttest{
data("hospital_actlog")
detect_value_range_violations(activitylog = hospital_actlog,
     triagecode = domain_numeric(from = 0, to = 5))
}
}
\seealso{
\code{\link{domain_categorical}},\code{\link{domain_time}},\code{\link{domain_numeric}}
}
