% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_details}
\alias{cvd_area_details}
\title{Area details}
\usage{
cvd_area_details(time_period_id = 1, area_id = 1)
}
\arguments{
\item{time_period_id}{integer - specified time period for which to return details for, i.e. population and participation rate (compulsory)}

\item{area_id}{integer - specified area id for which to return details for.}
}
\value{
Named list of tibbles containing area 'area_details', child 'area_child_details' (where appropriate) and parent 'area_parent_details' (where appropriate)
}
\description{
Returns details of a specific area at a given time period, including details about any parent and child areas.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2F\%3Carea_id\%3E\%2Fdetails}{Area details}
}
\examples{
# to see details for '3 Centres PCN' (area_id = 1103) use the following:
# get the list of tibbles from the function
returned_list <- cvd_area_details(time_period_id = 17, area_id = 1103)

# view area details
returned_list$area_details |>
  dplyr::select(AreaCode, AreaName)

# view details for the parent of this area
returned_list$area_parent_details |>
  dplyr::select(AreaID, AreaName, SystemLevelID)

# view details for the children of this area
returned_list$area_child_details |>
  dplyr::select(AreaID, AreaName, SystemLevelID)
}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
