% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_resultsDate.R
\name{f.resultsDate}
\alias{f.resultsDate}
\title{Calculate date of results of a study}
\usage{
f.resultsDate(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.resultsDate`, a date.
}
\description{
Trial concept calculated: earliest date of results as recorded in the
register. At that date, results may have been incomplete and may have
been changed later.
For EUCTR, requires that results and preferrably also their history of
publication have been included in the collection, using
ctrLoadQueryIntoDb(queryterm = ..., euctrresultshistory = TRUE, con = ...).
Cannot be calculated for ISRCTN, which does not have a corresponding field.
}
\examples{
# fields needed
f.resultsDate()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.resultsDate",
  con = dbc)
trialsDf

}
