% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-array.R
\name{deriveArray}
\alias{deriveArray}
\alias{makeArray}
\alias{makeMR}
\title{Make a Categorical Array or Multiple Response variable}
\usage{
deriveArray(subvariables, name, selections, numeric = NULL, ...)

makeArray(subvariables, name, ...)

makeMR(subvariables, name, selections, ...)
}
\arguments{
\item{subvariables}{a list of Variable objects to bind together, or a
Dataset subset which contains only the Variables to bind.}

\item{name}{character, the name that the new Categorical Array variable
should have.}

\item{selections}{character (preferred, indicating the names of the
categories), or numeric (indicating the IDs of the categories
in the combined array, which may not be the same as in the original
variables - also note that a category's ID is not the same thing
as its \code{numeric_value}). Required for \code{makeMR}; optional for
\code{deriveArray}; ignored in \code{makeArray}.}

\item{numeric}{Logical indicating whether the array should be a numeric
array or categorical array. \code{NULL} the default will guess numeric if
all variables are known to be numeric and categorical if all are
categorical. If any subvariables are created from expressions, then
their type cannot be guessed and so \code{numeric} must be specified.}

\item{...}{Optional additional attributes to set on the new variable.}
}
\value{
A VariableDefinition that when added to a Dataset will create the
categorical-array or multiple-response variable. \code{deriveArray} will
make a derived array expression (or a derived multiple response expression
if \code{selections} are supplied), while \code{makeArray} and \code{makeMR}
return an expression that "binds" variables together, removing them from
independent existence.
}
\description{
In most situations we recommend using \code{deriveArray} which leaves your
subvariables in the dataset. \code{makeArray} \emph{removes} component subvariables
from your dataset. Array variables are composed of a set of "subvariables"
bound together for display  in the app. For example, you might have a set of
survey questions that ask how the respondent would rate a TV show from 1-5.
Array variables allow you to display all of their ratings in a compact table
rather than a set of distinct variables.
}
\examples{
\dontrun{
# Categorical Array - Variables from list of variables
ds$enjoy_cat2 <- deriveArray(
    list(ds$enjoy1, ds$enjoy2),
    "Enjoy activities"
)

# Categorical Array - Variables from var catalog
# (result is the same as `ds$enjoy_cat1` above)
ds$enjoy_cat2 <- deriveArray(
    ds[c("enjoy1", "enjoy2")],
    "Enjoy activities v2"
)

# Multiple Response (selections as character names)
ds$enjoy_mr1 <- deriveArray(
    list(ds$enjoy1, ds$enjoy2),
    "Enjoy activities very much or a little",
    selections = c("Very much", "A little")
)

# Numeric Array
ds$rating_numa <- deriveArray(
    list(ds$rating1, ds$rating2),
    "Activity Rating"
)

# Using VarDef to specify metadata (and thus needing to specify type)
ds$enjoy_mr <- deriveArray(
    list(
        VarDef(ds$enjoy1 == "Very much", name = "enjoy brand 1"),
        VarDef(ds$enjoy2 == "Very much", name = "enjoy brand 2")
    ),
    "Enjoy activities with custom names"
)

# Multiple Response (selections as ids, same as ds$enjoy_mr1)
# Be careful `ids(categories(ds$enjoy1))` is not necessarily the same as
# `values(categories(ds$enjoy1))`
ds$enjoy_mr1 <- deriveArray(
    list(ds$enjoy1, ds$enjoy2),
    "Enjoy activities very much or a little v2",
    selections = c(1, 2)
)
}
}
