% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dctp.R, R/pctp.R, R/qctp.R, R/rctp.R
\name{ctp}
\alias{ctp}
\alias{dctp}
\alias{pctp}
\alias{qctp}
\alias{rctp}
\title{The Complex Triparametric Pearson (CTP) Distribution}
\usage{
dctp(x, a, b, gamma)

pctp(q, a, b, gamma, lower.tail = TRUE)

qctp(p, a, b, gamma, lower.tail = TRUE)

rctp(n, a, b, gamma)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{a}{parameter a (real)}

\item{b}{parameter b (real)}

\item{gamma}{parameter \eqn{\gamma} (positive)}

\item{q}{vector of quantiles.}

\item{lower.tail}{if TRUE (default), probabilities are \eqn{P(X<=x)}, otherwise, \eqn{P(X>x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dctp} gives the pmf, \code{pctp} gives the distribution function, \code{qctp} gives the quantile function and \code{rctp} generates random values.

If \eqn{a = 0} the probability mass function, distribution function, quantile function and random generation function for the CBP distribution arise.
If \eqn{b = 0} the probability mass function, distribution function, quantile function and random generation function for the EBW distribution arise.
}
\description{
Probability mass function, distribution function, quantile function and random generation for the Complex Triparametric Pearson (CTP) distribution with parameters \eqn{a}, \eqn{b} and \eqn{\gamma}.
}
\details{
The CTP distribution with parameters \eqn{a}, \eqn{b} and \eqn{\gamma} has pmf
\deqn{f(x|a,b,\gamma) = C \Gamma(a+ib+x) \Gamma(a-ib+x) / (\Gamma(\gamma+x) x!), x=0,1,2,...} 
where \eqn{i} is the imaginary unit, \eqn{\Gamma(·)} the gamma function and 
\deqn{C = \Gamma(\gamma-a-ib) \Gamma(\gamma-a+ib) / (\Gamma(\gamma-2a) \Gamma(a+ib) \Gamma(a-ib))}
the normalizing constant.

If \eqn{a=0} the CTP is a Complex Biparametric Pearson (CBP) distribution, so the pmf of the CBP distribution is obtained.
If \eqn{b=0} the CTP is an Extended Biparametric Waring (EBW) distribution, so the pmf of the EBW distribution is obtained.																															  

The mean and the variance of the CTP distribution are
\eqn{E(X)=\mu=(a^2+b^2)/(\gamma-2a-1)} and \eqn{Var(X)=\mu(\mu+\gamma-1)/(\gamma-2a-2)}
so \eqn{\gamma > 2a + 2}.

It is underdispersed if \eqn{a < - (\mu + 1) / 2}, equidispersed if \eqn{a = - (\mu + 1) / 2} or overdispersed
if \eqn{a > - (\mu + 1) / 2}. In particular, if \eqn{a >= 0} the CTP is always overdispersed.
}
\examples{
# Examples for the function dctp
dctp(3,1,2,5)
dctp(c(3,4),1,2,5)

# Examples for the function pctp
pctp(3,1,2,3)
pctp(c(3,4),1,2,3)

# Examples for the function qctp
qctp(0.5,1,2,3)
qctp(c(.8,.9),1,2,3)

# Examples for the function rctp
rctp(10,1,1,3)

}
\references{
\insertRef{RCS2003}{cpd}

\insertRef{RCSO2004}{cpd}

\insertRef{ROC2018}{cpd}

\insertRef{COR2021}{cpd}
}
\seealso{
Functions for maximum-likelihood fitting of the CTP, CBP and EBW distributions: \code{\link{fitctp}}, \code{\link{fitcbp}} and \code{\link{fitebw}}.
}
