% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COSMIC_v3.2.R
\docType{data}
\name{COSMIC_v3.2}
\alias{COSMIC_v3.2}
\title{Mutational signatures data from COSMIC, Catalogue Of Somatic Mutations In
Cancer (v3.2 - March 2021)}
\format{
A list with two elements, \code{signature} and \code{etiology}.
\itemize{
\item \code{signature} is a list with the same structure as
\code{\link{signature}}.
\item \code{etiology} is a list with the same structure as
\code{\link{etiology}}.
}
}
\source{
\url{https://cancer.sanger.ac.uk/signatures/}.
}
\usage{
COSMIC_v3.2
}
\description{
Mutational signatures data from COSMIC, Catalogue Of Somatic Mutations In
Cancer (v3.2 - March 2021)
}
\section{Note}{

SBS10c, SBS10d, SBS91, SBS92, SBS93, SBS94 (total 6) new SBS signatures were
added in COSMIC v3.2. See the news from COSMIC release for more details
\url{https://cosmic-blog.sanger.ac.uk/cosmic-mutational-signatures-release-v3-2/}
}

\section{Remark}{

The signatures are all genome signatures. \cr See \link[ICAMS]{CatalogRowOrder}
in package ICAMS for the classification of mutation types.
}

\examples{
sbs96_sig_v3.2 <- COSMIC_v3.2$signature$GRCh37$SBS96

}
\keyword{datasets}
