% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onload.R
\name{set_cookie_response}
\alias{set_cookie_response}
\title{Set cookie via HTTP header}
\usage{
set_cookie_response(
  cookie_name,
  cookie_value,
  expiration = 90,
  secure_only = NULL,
  domain = NULL,
  path = NULL,
  same_site = NULL,
  http_only = FALSE,
  redirect = NULL,
  ...
)
}
\arguments{
\item{cookie_name}{The name of the cookie. Can contain any US-ASCII
characters except for: the control character, space, a tab, or separator
characters like ( ) < > @ , ; : \\ " / [ ] ? = \{ \}.}

\item{cookie_value}{The contents of the cookie as a single character value.}

\item{expiration}{Days after which the cookie should expire. To remove an
HttpOnly cookie, send a negative value for this attribute.}

\item{secure_only}{Logical indicating whether the cookie should only be
accessible via secure (\verb{https:}) requests (except on localhost).}

\item{domain}{The host to which the cookie will be sent (including
subdomains). If this is \code{NULL} (default) the cookie will only be sent to
the host of the page where this cookie was set (not including subdomains).}

\item{path}{The path that must exist in the requested URL for the browser to
send this cookie. Includes subdirectories.}

\item{same_site}{One of "strict", "lax" (default), or "none", indicating when
the cookie should be sent. When \code{same_site = "none"}, \code{secure_only} must be
\code{TRUE}.}

\item{http_only}{Logical indicating whether the cookie should only be sent as
part of an HTTP request. When this is \code{FALSE} (default), the cookie is
accessible to JavaScript via the \code{Document.cookie} property.}

\item{redirect}{A relative or absolute URL where the user should be sent
next. A typical case would be the same URL minus the query parameter that
triggered the Set-cookie response.}

\item{...}{Additional parameters passed on to \code{\link[shiny:httpResponse]{shiny::httpResponse()}}.}
}
\value{
A \code{\link[shiny:httpResponse]{shiny::httpResponse()}} that sets the cookie.
}
\description{
Send a \code{\link[shiny:httpResponse]{shiny::httpResponse()}} that sets a cookie in the user's browser. Note
that this does \emph{not} return a full shiny ui.
}
\examples{
set_cookie_response("my_cookie", "contents of my cookie")
set_cookie_response("my_cookie", "contents of my cookie", expiration = 10)
set_cookie_response(
  "my_cookie", "contents of my cookie",
  content = "Your cookie is set."
)
set_cookie_response(
  "my_cookie", "contents of my cookie",
  redirect = "/"
)
}
