% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_paramEst.R
\name{cov_spatial}
\alias{cov_spatial}
\title{Calculate spatial covariance.}
\usage{
cov_spatial(
  Dist.mat,
  cov.model = "exponential",
  cov.pars = c(1, 1),
  kappa = 0.5
)
}
\arguments{
\item{Dist.mat}{A matrix of scaled distances.}

\item{cov.model}{A string specifying the model for the correlation
function; defaults to \code{"exponential"}.
Options available in this package are: "\code{exponential}",
\code{"matern"}, and \code{"gaussian"}.}

\item{cov.pars}{Fixed values; not used in the function.}

\item{kappa}{Scalar; value of the smoothness parameter.}
}
\value{
This function returns a correlation matrix.
}
\description{
This function replaces the geoR function \code{cov.spatial}, which
is now defunct.
Options available in this package are: "\code{exponential}",
\code{"matern"}, and \code{"gaussian"}.
}
\examples{
Distmat <- as.matrix(dist(matrix(runif(20), ncol = 2), diag = TRUE, upper = TRUE))
C <- cov_spatial( Dist.mat = Distmat )

}
