% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_selection.R
\name{select_optimal_components_safe}
\alias{select_optimal_components_safe}
\title{Select optimal number of PLS components with cross-validation}
\usage{
select_optimal_components_safe(X, Y, max_comp = 15, verbose = TRUE)
}
\arguments{
\item{X}{First data matrix}

\item{Y}{Second data matrix}

\item{max_comp}{Maximum number of components to test (default: 15)}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{ncomp_optimal}}{Optimal number of components selected.}
\item{\code{RMSEP}}{Root Mean Squared Error of Prediction for each component.}
\item{\code{R2}}{R-squared values for each component.}
\item{\code{validation_method}}{Validation method used.}
\item{\code{pls_fit}}{Fitted PLS model object with optimal components.}
}
}
\description{
Determines the optimal number of Partial Least Squares components using
leave-one-out or k-fold cross-validation, with robust error handling.
}
\details{
default) or "CV" (k-fold cross-validation).
validation = "LOO".

The function fits PLS models with 1 to \code{max_comp} components,
evaluates each via cross-validation, and selects the number that minimizes
prediction error while avoiding overfitting.
}
