% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_ou.R
\name{estimate_factor_OU}
\alias{estimate_factor_OU}
\title{Estimate Factor Ornstein-Uhlenbeck model (Stan if available)}
\usage{
estimate_factor_OU(
  factors_data,
  data_prep = NULL,
  chains = 4,
  iter = 2000,
  seed = 1234,
  adapt1 = 0.98,
  adapt2 = 0.999,
  mtd1 = 12,
  mtd2 = 15,
  verbose = TRUE
)
}
\arguments{
\item{factors_data}{List with \code{scores_X}, \code{scores_Y}.}

\item{data_prep}{Optional preprocessed data (reserved).}

\item{chains, iter, seed}{Stan sampling controls.}

\item{adapt1, adapt2, mtd1, mtd2}{Advanced Stan controls.}

\item{verbose}{Logical; print progress/details.}
}
\value{
A list with posterior medians (\eqn{\phi}, \eqn{\mu}, \eqn{\beta}),
half-lives, coupling strength, pseudo-R2, and the fitted Stan object.
}
\description{
Estimates a multivariate OU with cross-equation coupling \eqn{Y_{t}} depending
on lagged \eqn{X_{t-1}} via a \eqn{\beta} matrix. Uses \pkg{cmdstanr} when
available, otherwise \pkg{rstan}, with a discrete AR(1) fallback.
}
\examples{
\donttest{
  # Create toy factor data
  set.seed(123)
  n <- 50
  X_scores <- matrix(rnorm(n * 2), n, 2)
  Y_scores <- matrix(rnorm(n * 2), n, 2)
  factors_data <- list(scores_X = X_scores, scores_Y = Y_scores)
  
  # Estimate OU model (reduce iterations for speed)
  ou_result <- estimate_factor_OU(factors_data, chains = 2, iter = 500, 
                                   verbose = FALSE)
  
  # Check half-lives
  print(ou_result$half_lives_Y)
}
}
