% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_contrast.R
\name{use_contrasts.AsIs}
\alias{use_contrasts.AsIs}
\title{AsIs method for use_contrasts}
\usage{
\method{use_contrasts}{AsIs}(
  factor_col,
  code_by = NA,
  reference_level = NA,
  set_intercept = NA,
  drop_trends = NA,
  labels = NULL,
  as_is = FALSE,
  ...
)
}
\arguments{
\item{factor_col}{A factor vector, eg from df$factorVarName}

\item{code_by}{A symbol to be evaluated}

\item{reference_level}{The level to use as the reference level, default NA}

\item{set_intercept}{The intercept to use, default NA}

\item{drop_trends}{The trends to drop, default NA}

\item{labels}{A vector of labels to apply to the matrix column names, default
NULL (no new labels)}

\item{as_is}{Logical, default FALSE, whether to leave the resulting matrix
as-is}

\item{...}{Additional arguments to be passed on}
}
\value{
A contrast coding matrix with labels and proper reference level
}
\description{
Evaluates \code{code_by}, then applies the appropriate use_contrasts method
}
\examples{

use_contrasts(gl(5,1), I(scaled_sum_code))

}
