% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_compindex.R
\name{calc_compindex}
\alias{calc_compindex}
\title{Calculating composite indicator automatically step by step}
\usage{
calc_compindex(
  x,
  avg_type = "simple",
  scaling_method = "min-max",
  vif_based_calc = FALSE,
  si_diff = 0.05
)
}
\arguments{
\item{x}{A Dataframe}

\item{avg_type}{Choosing average type. So far "simple", "geometric" and "harmonic" average are available}

\item{scaling_method}{Scaling method selection. So far "min-max" and "standardization" are available}

\item{vif_based_calc}{If TRUE, variable with highest VIF is removed at each step. Default value is FALSE}

\item{si_diff}{Tolerance for normalized Si calculation. Can be between 0 and 1}
}
\value{
A list of lists
}
\description{
Calculates composite indicator by excluding the least significant variable at each step.
}
\examples{
x <- data.frame(rnorm(20),rnorm(20),rnorm(20),rnorm(20))
calc_compindex(x, avg_type = "simple",
scaling_method = "min-max",
vif_based_calc = FALSE,
si_diff = 0.1)
}
