% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%ge\%}
\alias{\%ge\%}
\title{Perform greater than or equal comparison between two objects}
\usage{
x1 \%ge\% x2
}
\arguments{
\item{x1}{The first object to compare}

\item{x2}{The second object to compare}
}
\value{
A single TRUE or FALSE value indicating the results of the comparison.
}
\description{
The goal of the comparison operators is to return a TRUE
or FALSE value when any two objects are compared.  The operators provides a
simple, reliable equality check that allows comparing
of NULLs, NA values, and atomic data types without error. This operator
performs a greater than or equal comparison.

For data frames, the operator will compare all values in all columns, and return
a single TRUE if all values in the second data frame are greater than or equal
to the corresponding values in the first data frame.
}
\details{
Additional details...
}
\examples{
# Comparing of NULLs and NA
NULL \%ge\% NULL        # TRUE
NULL \%ge\% NA          # FALSE
NA \%ge\% NA            # TRUE
1 \%ge\% NULL           # FALSE
1 \%ge\% NA             # FALSE

# Comparing of atomic values
1 \%ge\% 1              # TRUE
2 \%ge\% 1              # TRUE
1 \%ge\% 2              # FALSE
"one" \%ge\% "one"      # TRUE
1 \%ge\% "one"          # FALSE
1 \%ge\% Sys.Date()     # FALSE
Sys.Date() \%ge\% 1     # TRUE (Sys.Date() is a number)

# Comparing of vectors
v1 <- c(0, 1, 2)
v2 <- c(1, 2, 3)
v3 <- c(2, 3, 4)
v1 \%ge\% v1            # TRUE
v1 \%ge\% v2            # FALSE
v2 \%ge\% v1            # TRUE
v3 \%ge\% v1            # TRUE

# Comparing of data frames
d1 <- data.frame(A = v1, B = v2)
d2 <- data.frame(A = v2, B = v3)
d1 \%ge\% d1            # TRUE
d1 \%ge\% d2            # FALSE
d2 \%ge\% d1            # TRUE

# Mixing it up
d1 \%ge\% NULL          # FALSE
v1 \%ge\% d1            # FALSE
1 \%ge\% v1             # FALSE
}
\seealso{
Other operators: 
\code{\link{\%eq\%}()},
\code{\link{\%gt\%}()},
\code{\link{\%le\%}()},
\code{\link{\%lt\%}()},
\code{\link{\%ne\%}()},
\code{\link{\%p\%}()}
}
\concept{operators}
