% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{colors3d}
\alias{colors3d}
\title{Map values to a 3D legend in RGB colorspace.}
\usage{
colors3d(data, trans = "none", order = 1, inversion = 1, opacity = NULL)
}
\arguments{
\item{data}{Matrix or data frame with 3 numeric columns.}

\item{trans}{Either "none" (defaut, histogram is rescaled) or "rank"
(histogram is flattened).}

\item{order}{Integer from 1 to 6, each denoting a unique permutation of
variables-to-color band mapping. Under the default value of 1, the 
three variables in `data` are respectively mapped onto the R, G, and B 
bands of colorspace.}

\item{inversion}{Integer from 1 to 8, each denoting a unique combination of
variables to reverse before mapping. Under the default value of 1, all 
three variables are mapped with positive values at the high end of the
color band. Together with the `order` parameter, this allows all possible
48 unique mappings of a given set of variables onto 3D colorspace.}

\item{opacity}{Not currently used.}
}
\value{
Character vector of colors.
}
\description{
This function returns a color value for each row of the 3-column dataset
supplied, by transforming the input data and using it as RGB values.
}
\examples{
d <- expand.grid(x = 1:49, y = 1:49)
d$z <- cos(sqrt((d$x-25)^2 + (d$y-25)^2))
plot(d[, 1:2], col = colors3d(d), pch = 15, cex = 2)

plot(d[, 1:2], col = colors3d(d, order = 2, inversion = 2), pch = 15, cex = 2)
}
