% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{colors2d}
\alias{colors2d}
\title{Map values to a 2D legend interpolated from 4 corner colors.}
\usage{
colors2d(
  data,
  colors = c("yellow", "green", "blue", "magenta"),
  xtrans = c("none", "log", "rank"),
  ytrans = c("none", "log", "rank")
)
}
\arguments{
\item{data}{Matrix or data frame with 2 numeric columns; they will map to x
and y.}

\item{colors}{Vector of 4 corner colors to interpolate, clockwise from upper
right.}

\item{xtrans, ytrans}{Transformation to apply to x and y variables before
applying a linear color mapping: either "none" (default), "log", or "rank".}
}
\value{
Character vector of colors.
}
\description{
This function returns a color value for each row of the 2-column dataset
supplied, based on a 2D color palette interpolated from 4 corner colors.
}
\examples{
plot(iris, 
     col = colors2d(iris[, c("Sepal.Length", "Sepal.Width")]), 
     pch = 19, cex = 2)
     
plot(iris, 
     col = colors2d(iris[, c("Sepal.Length", "Sepal.Width")],
                    colors = c("limegreen", "gold", "black", "dodgerblue"),
                    xtrans = "rank", ytrans = "rank"), 
     pch = 19, cex = 2)
}
