% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colortistry.R
\name{colortistry}
\alias{colortistry}
\title{Colortistry plot from Colorified palettes}
\usage{
colortistry(colors_list, border_color = NA)
}
\arguments{
\item{colors_list}{list of colors generated with \code{\link{colorify}}, see example}

\item{border_color}{default: NA, for no border, otherwise R grDevices color or hexcolor}
}
\value{
plot Colortistry plot of combined Colorified palettes
}
\description{
Colortistry plot from Colorified palettes
}
\examples{
colors_list <- list()
for (i in seq(100)) {
  colors_list[[i]] <- colorify(
  n = 100, 
  colors = "rainbow", 
  colors_lock = rep(c(TRUE,FALSE,FALSE,FALSE,FALSE), 20), 
  hf = 25/i, 
  lf = i/20)
  if (i \%\% 3) colors_list[[i]] <- colorify(
  n = 100, 
  colors = "rainbow", 
  colors_lock = rep(c(FALSE,FALSE,TRUE,FALSE,FALSE), 20), 
  hf = 30/i, 
  lf = i/20)
  if (i \%\% 4) colors_list[[i]] <- colorify(
  n = 100, 
  colors = "rainbow",
  colors_lock = rep(c(FALSE,FALSE,FALSE,TRUE,FALSE), 20), 
  hf = 50/i, 
  lf = i/40)
  if (i \%\% 5) colors_list[[i]] <- colorify(
  n = 100, 
  colors = "rainbow", 
  colors_lock = rep(c(FALSE,TRUE,FALSE,FALSE,FALSE), 20), 
  hf = 50/i, 
  sf = i/50)
}
colortistry(colors_list)
colortistry(colors_list, border_color = 'black')
}
\seealso{
Browse vignettes with \code{vignette("Introduction to coloRify")}
}
