% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg-D-OLS.R
\name{cointRegD}
\alias{cointRegD}
\title{Dynamic OLS}
\usage{
cointRegD(x, y, deter, kernel = c("ba", "pa", "qs", "tr"),
  bandwidth = c("and", "nw"), n.lead = NULL, n.lag = NULL,
  kmax = c("k4", "k12"), info.crit = c("AIC", "BIC"), demeaning = FALSE,
  check = TRUE, ...)
}
\arguments{
\item{x}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
RHS variables on which to apply the D-OLS estimation (see Details).}

\item{y}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
LHS variable(s) on which to apply the D-OLS estimation (see Details).
Has to be one-dimensional. If \code{matrix}, it may
have only one row or column, if \code{data.frame} just one column.}

\item{deter}{[\code{numeric} | \code{matrix} | \code{data.frame} |
            \code{NULL}]\cr
Deterministic variable to include in the equation (see Details). If it's
\code{NULL} or missing, no deterministic variable is included in the model.}

\item{kernel}{[\code{character(1)}]\cr
The kernel function to use for calculating the long-run variance.
Default is Bartlett kernel (\code{"ba"}), see Details for alternatives.}

\item{bandwidth}{[\code{character(1)} | \code{integer(1)}]\cr
The bandwidth to use for calculating the long-run variance.
Default is Andrews (1991) (\code{"and"}), an alternative is Newey West
(1994) (\code{"nw"}).}

\item{n.lead, n.lag}{[\code{numeric(1)} | \code{NULL}]\cr
Numbers of Leads and Lags (see Details). Default is \code{NULL}.}

\item{kmax}{[\code{character(1)}]\cr
Maximal value for lags and leads if generated automatically (see Details).
Default is \code{"k4"}.}

\item{info.crit}{[\code{character(1)}]\cr
Information criterion to use for the automatical calculation of lags and
leads. Default is \code{"AIC"}.}

\item{demeaning}{[\code{logical}]\cr
Demeaning of residuals in \code{\link{getLongRunVar}}.
Default is \code{FALSE}.}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}

\item{...}{Arguments passed to \code{\link{getBandwidthNW}}.}
}
\value{
[\code{cointReg}]. List with components:
\describe{
  \item{\code{beta} [\code{numeric}]}{
    coefficients of the regressors}

  \item{\code{delta} [\code{numeric}]}{
    coefficients of the deterministics}

  \item{\code{theta} [\code{numeric}]}{
    combined coefficients of \code{beta} and \code{delta}}

  \item{\code{sd.theta} [\code{numeric}]}{
    standard errors for \code{theta}}

  \item{\code{t.theta} [\code{numeric}]}{
    t-values for \code{theta}}

  \item{\code{p.theta} [\code{numeric}]}{
    p-values for \code{theta}}

  \item{\code{theta.all} [\code{numeric}]}{
    combined coefficients of \code{beta}, \code{delta} and the auxiliary
    leads-and-lags regressors}

  \item{\code{residuals} [\code{numeric}]}{
    D-OLS residuals (length depends on leads and lags)}

  \item{\code{omega.u.v} [\code{numeric}]}{
    conditional long-run variance based on OLS residuals}

  \item{\code{varmat} [\code{matrix}]}{
    variance-covariance matrix}

  \item{\code{Omega} [\code{list}]}{
    the whole long-run variance matrix and parts of it}

  \item{\code{bandwidth} [\code{list}]}{
    number and name of the calculated bandwidth}

  \item{\code{kernel} [\code{character}]}{
    abbr. name of kernel type}

  \item{\code{lead.lag} [\code{list}]}{
    leads-and-lags parameters}
}
}
\description{
Computes the Saikkonen (1990) Dynamic OLS estimator.
}
\details{
The equation for which the FM-OLS estimator is calculated:
\deqn{y = \delta \cdot D + \beta \cdot x + u}{y = \delta * D + \beta * x + u}
with \eqn{D} as the deterministics matrix.
Then \eqn{\theta = (\delta', \beta')'} is the full parameter vector.

Information about the D-OLS specific arguments:
\describe{
  \item{\code{n.lag}, \code{n.lead}}{A positive number to set the number
  of lags and leads. If at least one of them is equal to \code{NULL}
  (default), the function \code{\link{getLeadLag}} will be used to
  calculate them automatically (see Choi and Kurozumi (2012) for details).
  In that case, the following two arguments are needed.}

  \item{\code{kmax}}{Maximal value for lags and leads, when they are
  calculated automatically. If "k4", then the maximum is equal to
  \code{floor(4 * (x.T/100)^(1/4))}, else it's
  \code{floor(12 * (x.T/100)^(1/4))} with \code{x.T} is equal
  to the data's length. One of \code{"k4"} or \code{"k12"}.
  Default is \code{"k4"}.}

  \item{\code{info.crit}}{Information criterion to use for the automatical
  calculation of lags and leads. One of \code{"AIC"} or \code{"BIC"}.
  Default is \code{"AIC"}.}
}
}
\examples{
set.seed(1909)
x1 <- cumsum(rnorm(100, mean = 0.05, sd = 0.1))
x2 <- cumsum(rnorm(100, sd = 0.1)) + 1
x3 <- cumsum(rnorm(100, sd = 0.2)) + 2
x <- cbind(x1, x2, x3)
y <- x1 + x2 + x3 + rnorm(100, sd = 0.2) + 1
deter <- cbind(level = 1, trend = 1:100)
test <- cointRegD(x, y, deter, n.lead = 2, n.lag = 2,
                    kernel = "ba", bandwidth = "and")
print(test)
test2 <- cointRegD(x, y, deter, kmax = "k4", info.crit = "BIC",
                     kernel = "ba", bandwidth = "and")
print(test2)

}
\references{
\itemize{
    \item Phillips, P.C.B. and M. Loretan (1991): "Estimating Long Run
          Economic Equilibria," \emph{Review of Economic Studies}, 58,
          407--436,
          \href{http://dx.doi.org/10.2307/2298004}{DOI:10.2307/2298004}.
    \item Saikkonen, P. (1991): "Asymptotically Efficient Estimation of
          Cointegrating Regressions," \emph{Econometric Theory}, 7, 1--21,
          \href{http://dx.doi.org/10.1017/S0266466600004217}{DOI:10.1017/S0266466600004217}.
    \item Stock, J.H. and M.W. Watson (1993): "A Simple Estimator of
          Cointegrating Vectors in Higher Order Integrated Systems,"
          \emph{Econometrica}, 61, 783--820,
          \href{http://dx.doi.org/10.2307/2951763}{DOI:10.2307/2951763}.
  }
}
\seealso{
Other cointReg: \code{\link{cointRegFM}},
  \code{\link{cointRegIM}}, \code{\link{cointReg}},
  \code{\link{plot.cointReg}}, \code{\link{print.cointReg}}

Other D-OLS: \code{\link{getLeadLag}},
  \code{\link{getModD}}, \code{\link{makeLeadLagMatrix}}
}

