skip_if_no_tensorflow <- function() {
  have_tensorflow <- reticulate::py_module_available("tensorflow")
  if (!have_tensorflow)
    skip("tensorflow not available for testing")
}

test_that("Correct outcome format and size for base outcome1",
            {
              skip_if_no_tensorflow()
              outcome1 <- codez(amzn_aapl_fb[,-1], seq_len = 20, n_samp = 3, n_windows = 5, dates = as.Date(amzn_aapl_fb$Date))
              expect_equal(class(outcome1), "list")
              expect_equal(length(outcome1), 3)
              expect_equal(names(outcome1), c("history", "best_model", "time_log"))
              expect_equal(names(outcome1$best_model), c("predictions", "errors", "plot"))
              expect_equal(class(outcome1$history), "data.frame")
              expect_equal(dim(outcome1$history), c(3, 24))
              expect_equal(length(outcome1$best_model$predictions), 3)
              expect_equal(class(outcome1$best_model$predictions), "list")
              expect_equal(all(sapply(outcome1$best_model$predictions, is.data.frame)), TRUE)
              expect_equal(dim(outcome1$best_model$predictions$AMZN), c(20, 17))
              expect_equal(dim(outcome1$best_model$predictions$GOOGL), c(20, 17))
              expect_equal(dim(outcome1$best_model$predictions$FB), c(20, 17))
              expect_equal(all(rownames(outcome1$best_model$predictions$AMZN) == paste0("t", 1:20)), FALSE)
              expect_equal(class(outcome1$best_model$errors), c("matrix", "array"))
              expect_equal(class(outcome1$best_model$plot), c("list"))
              expect_equal(class(outcome1$best_model$plot$AMZN), c("gg", "ggplot"))
              expect_equal(class(outcome1$best_model$plot$GOOGL), c("gg", "ggplot"))
              expect_equal(class(outcome1$best_model$plot$FB), c("gg", "ggplot"))
              expect_equal(dim(outcome1$best_model$errors), c(3, 13))
              expect_equal(class(outcome1$time_log)[1], "Period")
            })


test_that("Correct outcome format and size for base outcome2",
          {
            skip_if_no_tensorflow()
            outcome2 <- codez(amzn_aapl_fb[,2,drop = FALSE], seq_len = 50, n_samp = 1, n_windows = 3)
            expect_equal(class(outcome2), "list")
            expect_equal(length(outcome2), 3)
            expect_equal(names(outcome2), c("history", "best_model", "time_log"))
            expect_equal(names(outcome2$best_model), c("predictions", "errors", "plot"))
            expect_equal(class(outcome2$history), "data.frame")
            expect_equal(dim(outcome2$history), c(1, 24))
            expect_equal(length(outcome2$best_model$predictions), 1)
            expect_equal(class(outcome2$best_model$predictions), "list")
            expect_equal(all(sapply(outcome2$best_model$predictions, is.data.frame)), TRUE)
            expect_equal(dim(outcome2$best_model$predictions$AMZN), c(50, 17))
            expect_equal(rownames(outcome2$best_model$predictions$AMZN), paste0("t", 1:50))
            expect_equal(class(outcome2$best_model$errors), c("matrix", "array"))
            expect_equal(class(outcome2$best_model$plot), c("list"))
            expect_equal(class(outcome2$best_model$plot$AMZN), c("gg", "ggplot"))
            expect_equal(dim(outcome2$best_model$errors), c(1, 13))
            expect_equal(class(outcome2$time_log)[1], "Period")
          })
