% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcnb.R
\name{qcnb}
\alias{qcnb}
\title{Quantile Function of Conditional Negative Binomial}
\usage{
qcnb(p, D, r1, r2, lambda)
}
\arguments{
\item{p}{a nonempty vector of probabilities (0 <= p[i] <= 1 for all i).}

\item{D}{a positive integer.}

\item{r1}{a positive value.}

\item{r2}{a positive value.}

\item{lambda}{a positive value.}
}
\value{
A vector x such that x[i] = Inf\{x in 0:D, p[i] <= Pr(X <= x | X + Y = D)\} for all i.
}
\description{
Quantile function of the conditional distribution of X given X + Y = D,
where X ~ NB(r1, p1) and Y ~ NB(r2, p2) are drawn from two negative binomials,
independent of each other,
and assuming p1/p2 = lambda.
}
\details{
Need to specify full list of arguments, as default values have not been set.
}
\examples{
qcnb(0.035193, 2000, 120, 90, 0.994)
qcnb(seq(0, 1, 0.05), 7, 2, 0.4, 0.6)

}
\seealso{
\code{\link{dcnb}, \link{pcnb}, \link{rcnb}.}
}
\author{
Xiaotian Zhu, \email{xiaotian.zhu.psualum@gmail.com}
}
