% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plothist.R
\name{plothist}
\alias{plothist}
\title{Create a histogram of randomised deltaAICc values}
\usage{
plothist(dataset, datasetrand, verbose = TRUE)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate
windows from observed data. Output from \code{\link{slidingwin}}.}

\item{datasetrand}{A dataframe containing information on all fitted climate 
windows using randomised data. Output from \code{\link{randwin}}.}

\item{verbose}{TRUE or FALSE. Should messages and warnings be printed while running
function? Default: TRUE}
}
\value{
plothist will return a histograms of deltaAICc values from 
 randomised data. Values of PdeltaAICc and Pc will be provided to help 
 determine the likelihood that an observed deltaAICc value would occur
 by chance.
}
\description{
Create a histogram of deltaAICc values from randomised data.
}
\examples{
# Plot randomised data for the Mass dataset

data(MassOutput)
data(MassRand)

plothist(datasetrand = MassRand, dataset = MassOutput)

}
\author{
Liam D. Bailey and Martijn van de Pol
}
