% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_imgw_datastore.R
\name{meteo_imgw_datastore}
\alias{meteo_imgw_datastore}
\title{IMGW meteorological data from the IMGW datastore repository}
\usage{
meteo_imgw_datastore(
  year,
  parameters = NULL,
  stations = NULL,
  coords = TRUE,
  allow_failure = TRUE
)
}
\arguments{
\item{year}{numeric vector of years to be downloaded (e.g., 2022:2023)}

\item{parameters}{\itemize{
\item character vector describing which parameters to be downloaded. Default \code{NULL} means to download all available.
\enumerate{
\item "wd" - wind direction (degrees)
\item "t2m" - temperature at 2 metres above ground level (degree Celsius)
\item "t0m" - ground temperature (degree Celsius)
\item "rr_24h" - precipitation totals for last 24 hours (mm)
\item "rr_1h" - precipitation totals for last 1 hour (mm)
\item "rr_10min" - precipitation totals for last 10 minutes (mm)
\item "ws" - wind speed (m/s)
\item "ws_max" - maximum wind speed for last 10 minutes (m/s)
\item "gust" - wind gust (if present) (m/s)
\item "rh" - relative humidity (\%)
\item "water_in_snow" - water equivalent of melted snow cover (mm)
}
}}

\item{stations}{\itemize{
\item character vector with station names as visible in the \code{meteo_imgw_telemetry_stations()}.
Default \code{NULL} means to download data for all available stations.
}}

\item{coords}{\itemize{
\item logical - whether to append the dataset with station full name, longitude, latitude and altitude. Default: TRUE
}}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}
}
\value{
data.table with a raw meteorological measurements in 10-min intervals.
Please note that this dataset is not validated by experts and may contain invalid values.
}
\description{
Downloading hourly (meteorological) data from the telemetric stations
available in the danepubliczne.imgw.pl/datastore collection since 2008.
Most parameters are collected with 10 minutes interval and thus it is recommended to download only the mandatory years, parameters or stations.
For example, 1 year of data with all available parameters requires processing around 4GB of uncompressed data.
}
\details{
Data from the IMGW automated (telemetry) systems are non validated by experts and may contain invalid values.
}
\examples{
\donttest{
imgw_telemetry = meteo_imgw_datastore(year = 2022:2023,
                                      parameters = "t2m",
                                      stations = c("HALA GĄSIENICOWA",
                                                   "DOLINA 5 STAWÓW"),
                                      coords = TRUE)
}

}
