% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_surf.R
\name{mask_surf}
\alias{mask_surf}
\title{Mask surface}
\usage{
mask_surf(surf, mask)
}
\arguments{
\item{surf}{A \code{"surf"} object}

\item{mask}{A length \eqn{V} logical vector indicating if each vertex is
within the input mask.}
}
\value{
The masked \code{"surf"} object.
}
\description{
Mask a surface mesh.
}
\details{
Apply a binary mask to a \code{"surf"} object (list of vertices and
corresponding faces). Vertices not in the mask are removed, and faces
(triangles) with any vertices not in the mask are removed. Finally,
vertex numbering for the new faces matrix is corrected.
}
\seealso{
Other surface-related: 
\code{\link{add_surf}()},
\code{\link{boundary_mask_surf}()},
\code{\link{edit_mask_surf}()},
\code{\link{even_vert_samp}()},
\code{\link{is.surf}()},
\code{\link{load_surf}()},
\code{\link{read_surf}()},
\code{\link{resample_surf}()},
\code{\link{rotate_surf}()},
\code{\link{surf_area}()},
\code{\link{view_surf}()},
\code{\link{write_surf_gifti}()}
}
\concept{surface-related}
