% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_surf.R
\name{dist_from_mask_surf}
\alias{dist_from_mask_surf}
\title{Distance from mask on surface}
\usage{
dist_from_mask_surf(faces, mask, boundary_width = 10)
}
\arguments{
\item{faces}{An \eqn{F \times 3} matrix, where each row contains the vertex
indices for a given triangular face in the mesh. \eqn{F} is the number of
faces in the mesh.}

\item{mask}{A length \eqn{V} logical vector indicating if each vertex is
within the input mask.}

\item{boundary_width}{A positive integer representing the width of the
boundary to compute. The furthest vertices from the input mask will be this
number of edges away from the closest vertex in the input mask. Default:
\code{10}.}
}
\value{
A length-V numeric vector. Each entry corresponds to the vertex
with the same index. For vertices within the boundary, the value will be the
number of vertices away from the closest vertex in the input mask.
Vertices inside the input mask but at the edge of it (i.e. the vertices
that define the boundary) will have value 0. Then, all other vertices will
have value -1.
}
\description{
Identify the vertices within \code{boundary_width} edges of a vertex in the
input mask on a triangular mesh. Returns the number of edges a vertex is
away from the closest mask vertex.
}
\keyword{internal}
