% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chyper.R
\name{mleM}
\alias{mleM}
\title{Maximum likelihood estimator for sample size in conditional hypergeometric distributions}
\usage{
mleM(population, k, s, n, m, verbose = T)
}
\arguments{
\item{population}{the index of the unknown sample size}

\item{k}{the observed overlaps}

\item{s}{an integer representing the size of the intersecting population}

\item{n}{a vector of integers representing the sizes of each non-intersecting population}

\item{m}{a vector of integers representing the sample sizes where the value of the unknown sample size should be any integer as a placeholder}

\item{verbose}{T/F should intermediate messages be printed?}
}
\value{
The maximum likelihood estimator of the unknown sample size
}
\description{
Calculates the MLE of a sample size in a conditional hypergeometric distribution: the distribution of how many items are in the overlap of all samples when samples of arbitrary size are each taken without replacement from populations of arbitrary size.
}
\examples{
mleM(1, c(0,0,1,1,0,2,0), 8, c(12,13,14), c(0,8,9))

}
