% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chilling.R
\name{chilling}
\alias{chilling}
\title{Calculation of chilling and heat from hourly temperature records}
\usage{
chilling(
  hourtemps = NULL,
  Start_JDay = 1,
  End_JDay = 366,
  THourly = NULL,
  misstolerance = 50
)
}
\arguments{
\item{hourtemps}{a list of two elements, with element 'hourtemps' being a
dataframe of hourly temperatures (e.g. produced by stack_hourly_temps). This
data frame must have a column for Year, a column for JDay (Julian date, or
day of the year), a column for Hour and a column for Temp (hourly
temperature). The second (optional) element is QC, which is a data.frame
indicating completeness of the dataset. This is automatically produced by
stack_hourly_temps.}

\item{Start_JDay}{the start date (in Julian date, or day of the year) of the
period, for which chill and heat should be quantified.}

\item{End_JDay}{the end date (in Julian date, or day of the year) of the
period, for which chill and heat should be quantified.}

\item{THourly}{the same as hourtemps. This argument is only retained for
downward compatibility and can be ignored in most cases.}

\item{misstolerance}{maximum percentage of values for a given season that
can be missing without the record being removed from the output. Defaults to
50.}
}
\value{
data frame showing chilling and heat totals for the respective
periods for all seasons included in the temperature records. Columns are
Season, End_year (the year when the period ended), Days (the duration of the
period), Chilling_Hours, Utah_Model, Chill_portions and GDH. If the weather
input consisted of a list with elements hourtemps and QC, the output also
contains columns from QC that indicate the completeness of the weather
record that the calculations are based on.
}
\description{
Function to calculate three common horticultural chill metrics and one heat
metric from stacked hourly temperatures (produced by stack_hourly_temps).
Metrics that are calculated are Chilling Hours, Chill Units according to the
Utah Model, Chill Portions according to the Dynamic Model and Growing Degree
Hours.
}
\details{
Chill metrics are calculated as given in the references below. Chilling
Hours are all hours with temperatures between 0 and 7.2 degrees C. Units of
the Utah Model are calculated as suggested by Richardson et al. (1974)
(different weights for different temperature ranges, and negation of
chilling by warm temperatures). Chill Portions are calculated according to
Fishman et al. (1987a,b). More honestly, they are calculated according to an
Excel sheet produced by Amnon Erez and colleagues, which converts the
complex equations in the Fishman papers into relatively simple Excel
functions. These were translated into R. References to papers that include
the full functions are given below. Growing Degree Hours are calculated
according to Anderson et al. (1986), using the default values they suggest.
}
\note{
After doing extensive model comparisons, and reviewing a lot of
relevant literature, I do not recommend using the Chilling Hours or Utah
Models, especially in warm climates! The Dynamic Model (Chill Portions),
though far from perfect, seems much more reliable.
}
\examples{

# weather <- fix_weather(KA_weather[which(KA_weather$Year > 2006), ])
# hourtemps <- stack_hourly_temps(weather, latitude = 50.4)
# chilling(hourtemps, 305, 60)

chilling(stack_hourly_temps(fix_weather(KA_weather[which(KA_weather$Year > 2006), ]),
         latitude = 50.4))

}
\references{
Model references:

Chilling Hours:

Weinberger JH (1950) Chilling requirements of peach varieties. Proc Am Soc
Hortic Sci 56, 122-128

Bennett JP (1949) Temperature and bud rest period. Calif Agric 3 (11), 9+12

Utah Model:

Richardson EA, Seeley SD, Walker DR (1974) A model for estimating the
completion of rest for Redhaven and Elberta peach trees. HortScience 9(4),
331-332

Dynamic Model:

Erez A, Fishman S, Linsley-Noakes GC, Allan P (1990) The dynamic model for
rest completion in peach buds. Acta Hortic 276, 165-174

Fishman S, Erez A, Couvillon GA (1987a) The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. J Theor Biol 126(3), 309-321

Fishman S, Erez A, Couvillon GA (1987b) The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. J Theor Biol 124(4), 473-483

Growing Degree Hours:

Anderson JL, Richardson EA, Kesner CD (1986) Validation of chill unit and
flower bud phenology models for 'Montmorency' sour cherry. Acta Hortic 184,
71-78

Model comparisons and model equations:

Luedeling E, Zhang M, Luedeling V and Girvetz EH, 2009. Sensitivity of
winter chill models for fruit and nut trees to climatic changes expected in
California's Central Valley. Agriculture, Ecosystems and Environment 133,
23-31

Luedeling E, Zhang M, McGranahan G and Leslie C, 2009. Validation of winter
chill models using historic records of walnut phenology. Agricultural and
Forest Meteorology 149, 1854-1864

Luedeling E and Brown PH, 2011. A global analysis of the comparability of
winter chill models for fruit and nut trees. International Journal of
Biometeorology 55, 411-421

Luedeling E, Kunz A and Blanke M, 2011. Mehr Chilling fuer Obstbaeume in
waermeren Wintern? (More winter chill for fruit trees in warmer winters?).
Erwerbs-Obstbau 53, 145-155

Review on chilling models in a climate change context:

Luedeling E, 2012. Climate change impacts on winter chill for temperate
fruit and nut production: a review. Scientia Horticulturae 144, 218-229

The PLS method is described here:

Luedeling E and Gassner A, 2012. Partial Least Squares Regression for
analyzing walnut phenology in California. Agricultural and Forest
Meteorology 158, 43-52.

Wold S (1995) PLS for multivariate linear modeling. In: van der Waterbeemd H
(ed) Chemometric methods in molecular design: methods and principles in
medicinal chemistry, vol 2. Chemie, Weinheim, pp 195-218.

Wold S, Sjostrom M, Eriksson L (2001) PLS-regression: a basic tool of
chemometrics. Chemometr Intell Lab 58(2), 109-130.

Mevik B-H, Wehrens R, Liland KH (2011) PLS: Partial Least Squares and
Principal Component Regression. R package version 2.3-0.
http://CRAN.R-project.org/package0pls.

Some applications of the PLS procedure:

Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat
requirements of cherry trees - a statistical approach. International Journal
of Biometeorology 57,679-689.

Yu H, Luedeling E and Xu J, 2010. Stronger winter than spring warming delays
spring phenology on the Tibetan Plateau. Proceedings of the National Academy
of Sciences (PNAS) 107 (51), 22151-22156.

Yu H, Xu J, Okuto E and Luedeling E, 2012. Seasonal Response of Grasslands
to Climate Change on the Tibetan Plateau. PLoS ONE 7(11), e49230.

The exact procedure was used here:

Luedeling E, Guo L, Dai J, Leslie C, Blanke M, 2013. Differential responses
of trees to temperature variation during the chilling and forcing phases.
Agricultural and Forest Meteorology 181, 33-42.

The chillR package:

Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat
requirements of cherry trees - a statistical approach. International Journal
of Biometeorology 57,679-689.
}
\author{
Eike Luedeling
}
\keyword{and}
\keyword{calculation}
\keyword{chill}
\keyword{heat}
