% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClimateWizardData.R
\name{getClimateWizardData}
\alias{getClimateWizardData}
\title{Extract climate data from the ClimateWizard database}
\usage{
getClimateWizardData(
  coordinates,
  scenario,
  start_year,
  end_year,
  baseline = c(1950, 2005),
  metric = "monthly_min_max_temps",
  GCMs = "all",
  temperature_generation_scenarios = FALSE
)
}
\arguments{
\item{coordinates}{position of the point of interest, specified by a vector
with two elements that are called longitude and latitude (e.g. \code{c(longitude = 10,
latitude = 20)}).}

\item{scenario}{representative concentration pathway scenario. Can only be
"historical", "rcp45" or "rcp85".}

\item{start_year}{start year of the interval, for which data is to be summarized.}

\item{end_year}{end year of the interval, for which data is to be summarized.}

\item{baseline}{numeric vector of length 2 indicating the time interval to be used
as baseline for the climate scenario. The function then returns projected values relative
to this baseline. Defaults to \code{c(1950, 2005)} for the standard
baseline of the ClimateWizard dataset. This can also assume different values, but it must
span an interval of at least 20 years within the [1950; 2005] interval. Needs
to be set to NA for the function to return absolute values.}

\item{metric}{vector of metrics to output, from a list specified in the reference
provided above. This can also be "monthly_min_max_temps", which returns all
mean monthly minimum and maximum temperatures, or "precipitation" for precipitation
data for all months, or "monthly_tmean" for the mean monthly temperatures of all months.}

\item{GCMs}{vector of GCMs to be accessed, from a list specified in the above
reference. This can also be "all" for all available GCMs (as of January 2018).}

\item{temperature_generation_scenarios}{parameter to indicate whether the scenarios to be
generated should be formatted in such a way that they are directly usable by
chillR's temperature_generation function. This is only applicable, when \code{metric ==
'monthly_min_max_temps'}.}
}
\value{
data.frame containing the requested information.
}
\description{
This function makes use of an API provided by the International
Center for Tropical Agriculture (CIAT) to access climate scenario
data for a location of interest. Climate model runs are queried
and data returned and summarized according to the specified parameters.
A number of metrics are available for several climate models, which are listed in the
\href{https://github.com/CIAT-DAPA/climate_wizard_api}{API repository}.
Refer to this document for details on what can be downloaded. This function
provides the additional option of automatically retrieving all data referring to changes
in daily temperature extremes (by month), by setting the ```metric``` parameter to
"monthly_min_max_temps". It also offers the option to automatically obtain data for
all climate models included in the database (as of January 2018).
}
\examples{

# the example is #d out, since the download request sometimes times out, and that
# causes problems with CRAN approval of the package

# getClimateWizardData(coordinates=c(longitude=10.613975,latitude=34.933439),
#   scenario="rcp45", start_year=2020, end_year=2050,
#   metric=c("CD18","R02"), GCMs=c("bcc-csm1-1","BNU-ESM"))


}
\references{
Girvetz E, Ramirez-Villegas J, Navarro C, Rodriguez C, Tarapues J, undated.
ClimateWizard REST API for querying climate change data.
https://github.com/CIAT-DAPA/climate_wizard_api
}
\author{
Eike Luedeling
}
\keyword{utility}
