% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/before_after_JDay.R
\name{JDay_count}
\alias{JDay_count}
\title{Count days between two Julian dates}
\usage{
JDay_count(start_date, end_date, season = NA, leap_year = FALSE)
}
\arguments{
\item{start_date}{integer ranging from 1 to 366, indicating a Julian date.
This is the start date of the interval of interest.}

\item{end_date}{integer ranging from 1 to 366, indicating a Julian date.
This is the end date of the interval of interest.}

\item{season}{integer vector of length 2, specifying the beginning and end
of the phenology season, respectivcely. If this is not specified, the
start_date and end_date are used to define the season.}

\item{leap_year}{either a Boolean parameter indicating whether the count
should be done for a leap year, or an integer specyfing the year, for
which the calculation is to be done. The function then determines
automatically, whether this is a leap year.}
}
\value{
Boolean result (TRUE/FALSE) of the comparison.
}
\description{
This function counts the days between two Julian dates, taking into
account whether the season extends past the end of a calender year and
whether the count is to be done for a leap year.
}
\examples{

JDay_count(start_date=320,end_date=20,season=c(305,59),leap_year=2004)

}
\author{
Eike Luedeling
}
\keyword{Julian}
\keyword{date}
\keyword{phenology}
\keyword{season}
