% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/molNet.R
\name{molNet}
\alias{molNet}
\title{Generate a molecular network with some properties}
\usage{
molNet(compDisMat, npcTable = NULL, cutOff = "median")
}
\arguments{
\item{compDisMat}{Compound dissimilarity matrix, as calculated by
\code{\link{compDis}}. Note that the supplied dissimilarity matrix
is transformed into a similarity matrix, and this is what \code{cutOff}
values are set for. Note also that \code{\link{compDis}} always outputs a
list of one or more matrices, while \code{molNet} requires a single matrix
as input. Therefore, a specific matrix has to be selected from this list,
as \code{compDisOutput$matrix}.}

\item{npcTable}{A data frame generated by \code{\link{NPCTable}} can
be supplied for calculations of the number of NPC pathways and
network modularity.}

\item{cutOff}{Cut-off value for compound similarities. Any similarity
lower than this value will be set to zero when the network is generated,
which strongly affects the look of the network. The value can be set
manually to any value between 0 and 1; to the \code{median} similarity
value from the compDisMat; or, if an NPCTable is supplied,
to \code{minPathway}, the lowest within-pathway similarity
(which allows all within-NPC-pathway similarities to be kept).}
}
\value{
List with a (tbl_graph) graph object, the number of compounds,
number of NPC pathways and a measure of the modularity of the network
(see \code{\link[igraph]{modularity}}).
}
\description{
Function to generate a molecular network object, and some
basic properties of the network.
}
\details{
Molecular networks can be used to illustrate the biosynthetic/structural
similarity of phytochemical compounds in a sample, while
simultaneously visualizing their relative concentrations. \code{molNet}
creates the network, and \code{\link{molNetPlot}} can subsequently be
used to create a plot of the network.
}
\examples{
data(minimalCompDis)
data(minimalNPCTable)
molNet(minimalCompDis, minimalNPCTable, cutOff = 0)

data(alpinaCompDis)
molNet(compDisMat = alpinaCompDis, cutOff = 0.75)
}
