% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checker.R
\name{chk_requirements}
\alias{chk_requirements}
\title{Check R set up before a class}
\usage{
chk_requirements(path = system.file("default.yaml", package = "checker"))
}
\arguments{
\item{path}{path to yaml file.
Defaults to a file that comes with the package.}
}
\value{
No return value, output is printed
}
\description{
Checks that the required versions of 'R', 'RStudio', 'R' packages
and other dependencies are installed.
}
\details{
\code{chk_requirements()} checks that the computer set up before class.
It check
\itemize{
\item 'R' version
\item 'RStudio' version
\item 'RStudio' options
\item 'R' packages are installed (with version if necessary)
\item 'git' version
\item 'quarto' version
}

These requirements are specified in a yaml file specified by the \code{path}
argument which can be on the users computer or at a URL.
If not set, the function defaults to using a built-in yaml file, which may
not require the latest version.
}
\examples{
chk_requirements()
}
