% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lobby}
\alias{lobby}
\title{Find the lobby index (centrality)}
\usage{
lobby(graph, vids = V(graph), mode = c("all", "out", "in"), loops = TRUE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character constatnt, it specifies how to use the direction of the edges if a directed graph is analyzed. For 'out' only the outgoing edges are followed. For 'in' all vertices from which the source vertex is reachable in at most order steps are counted. 'all' ignores the direction of the edges. This argument is ignored for undirected graphs.}

\item{loops}{Logical; whether the loop edges are also counted.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
The l-index or lobby index of a node \eqn{x}{x} is the largest integer \eqn{k}{k} such that \eqn{x}{x} has at least \eqn{k}{k} neighbors with a degree of at least \eqn{k}{k}.
}
\details{
For more detail at \href{http://www.centiserver.org/?q1=centrality&q2=Lobby_Index}{Lobby Index}
}
\examples{
g <- random.graph.game(20, 3/10)
lobby(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Korn, A., A. Schubert, and A. Telcs. "Lobby index in networks." Physica A: Statistical Mechanics and its Applications 388.11 (2009): 2221-2226.
}

