% Generated by roxygen2 (4.0.2): do not edit by hand
\name{entropy}
\alias{entropy}
\title{Find the entropy centrality in a graph}
\usage{
entropy(graph, vids = V(graph), mode = c("all", "out", "in"),
  weights = NULL)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character constant, gives whether the shortest paths to or from the given vertices should be calculated for directed graphs. If out then the shortest paths from the vertex, if in then to it will be considered. If all, the default, then the corresponding undirected graph will be used, ie. not directed paths are searched. This argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is NULL, the default, and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute).}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Entropy centrality measures centrality of nodes depending on their contribution to the entropy of the graph.
}
\details{
The centrality entropy measures \eqn{H_{ce}}{H(ce)} of a graph G, defined as:
\deqn{H_{ce}(G)=-\sum_{i=1}^{n}\gamma(v_{i})\times log_{2}\gamma(v_{i})}{H(ce)G=-sum(gamma(v(i)) X log2(gamma(v(i))), i=1,n)}
where  \eqn{\gamma(v_{i})=\frac{paths(v_{i})}{paths(v_{1}, v_{2}, ..., v_{M})}}{gamma(v(i))=paths(v(i))/paths(v(1), v(2), ..., v(M))} where \eqn{paths(v_{i})}{paths(v(i))} is the number of geodesic paths from node \eqn{v_{i}}{v(i)} to all the other nodes in the graph and \eqn{paths(v_{1}, v_{2}, ..., v_{M})}{paths(v(1), v(2), ..., v(M))} is the total number of geodesic paths M that exists across all the nodes in the graph. \cr
The centrality entropy provides information on the degree of centrality for a node in the graph. Those nodes that will split the graph in two or that will reduce substantially the number of paths available to reach other nodes when removed, will have a higher impact in decreasing the total centrality entropy of a graph. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Entropy_Centrality}{Entropy Centrality}
}
\examples{
g <- erdos.renyi.game(10, 1/10)
entropy(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Ortiz-Arroyo, Daniel, and DM Akbar Hussain. "An information theory approach to identify sets of key players." Intelligence and Security Informatics. Springer Berlin Heidelberg, 2008. 15-26.
}

