% Generated by roxygen2 (4.0.2): do not edit by hand
\name{crossclique}
\alias{crossclique}
\title{Find the cross-clique connectivity (centrality)}
\usage{
crossclique(graph, vids = V(graph))
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
The cross-clique connectivity \eqn{X(v)}{X(v)} of a node is the number of cliques to which belongs. A node with a high \eqn{X(v)}{X(v)} value is called a highly cross-connected node.
}
\details{
Note: Directed graph considered as undirected ones and multiple edges and loops are ignored. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Cross-Clique_Connectivity}{Cross-Clique Connectivity}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2), directed=FALSE)
crossclique(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Faghani, M., and U. Nguyen. "A Study of XSS Worm Propagation and Detection Mechanisms in Online Social Networks." (2013): 1-1.
}

