% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energetics.R
\name{energetics_ols_summary}
\alias{energetics_ols_summary}
\title{Get ordinary least squares mean and confidence intervals from energetics}
\usage{
energetics_ols_summary(atp_col, error_metric, conf_int)
}
\arguments{
\item{atp_col}{The column name of the ATP measure - one of "ATP_basal_resp",
"ATP_max_resp", "ATP_basal_glyc", "ATP_max_glyc"}

\item{error_metric}{Whether to calculate error as standard deviation (\code{"sd"}) or confidence intervals (\code{"ci"})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and
1}
}
\value{
a data.table with mean and the confidence interval bounds by
experimental group
}
\description{
Helper function to calculate mean and standard deviation of ATP production
from glycolysis and OXPHOS at points defined in \code{partition_data} and with
values calculated using the \code{get_energetics} function. Should only be called
from \code{get_energetics_summary} as the function itself only operaes on a
vector without any of the grouping that \code{get_energetics} does.
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
partitioned_data <- partition_data(seahorse_rates)
energetics <- get_energetics(partitioned_data, ph = 7.4, pka = 6.093, buffer = 0.1)
# Only for one row and across all groups and replicates.
# For the full correctly grouped energetics table run
# `get_energetics_summary` with `model = "ols"`.
energetics_ols_summary(energetics$ATP_max_resp, error_metric = "ci", conf_int = 0.95)
}
