% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alt_Parkhomenko.R
\name{SCCA_Parkhomenko}
\alias{SCCA_Parkhomenko}
\title{Function to perform Sparse CCA based on Waaijenborg et al. (2008)
REFERENCE Parkhomenko et al. (2009), "Sparse Canonical Correlation Anlaysis with Application to Genomic Data Integration" in  Statistical Applications in Genetics and Molecular Biology, Volume 8, Issue 1, Article 1}
\usage{
SCCA_Parkhomenko(
  x.data,
  y.data,
  n.cv = 5,
  lambda.v.seq = seq(0, 0.2, by = 0.02),
  lambda.u.seq = seq(0, 0.2, by = 0.02),
  Krank = 1,
  standardize = TRUE
)
}
\arguments{
\item{x.data}{Matrix of predictors (n x p)}

\item{y.data}{Matrix of responses (n x q)}

\item{n.cv}{Number of cross-validation folds (default is 5)}

\item{lambda.v.seq}{Vector of sparsity parameters for Y (default is a sequence from 0 to 1 with step 0.1)}

\item{lambda.u.seq}{Vector of sparsity parameters for X (default is a sequence from 0 to 1 with step 0.1)}

\item{Krank}{Number of canonical components to extract}

\item{standardize}{Standardize (center and scale) the data matrices X and Y (default is TRUE) before analysis}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{cor}{Canonical correlations}
}
}
\description{
Function to perform Sparse CCA based on Waaijenborg et al. (2008)
REFERENCE Parkhomenko et al. (2009), "Sparse Canonical Correlation Anlaysis with Application to Genomic Data Integration" in  Statistical Applications in Genetics and Molecular Biology, Volume 8, Issue 1, Article 1
}
