% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_causens}
\alias{plot_causens}
\title{Plot ATE with respect to sensitivity function value
when it is constant, i.e. c(1, e) = c1 and c(0, e) = c0.}
\usage{
plot_causens(
  trt_model,
  data,
  outcome,
  c1_upper = 0.5,
  c1_lower = 0,
  r = 1,
  by = 0.01
)
}
\arguments{
\item{trt_model}{The treatment model object as a formula or fitted glm.}

\item{data}{A data frame containing the variables of interest.}

\item{outcome}{The name of the outcome variable.}

\item{c1_upper}{The upper bound for the sensitivity function value.}

\item{c1_lower}{The lower bound for the sensitivity function value.}

\item{r}{The ratio between c1 and c0.}

\item{by}{The increment for the sensitivity function value.}
}
\value{
A plot of the ATE as a function of c1 values.
}
\description{
This function plots 1) the ATE as a function of the sensitivity
function value when it is constant and 2) its associate 95% confidence
interval obtained via bootstrapping, if desired. The latter process can be
take a few seconds to minutes.
}
