% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_balance.R
\name{mean_balance}
\alias{mean_balance}
\title{Standardized absolute mean difference calculations}
\usage{
mean_balance(x = NULL, z = NULL, weights = NULL, ...)
}
\arguments{
\item{x}{Either a matrix, an object of class \linkS4class{dataHolder}, or an object of class DataSim}

\item{z}{A integer vector denoting the treatments of each observations. Can be null if \code{x} is a DataSim object or already of class \linkS4class{dataHolder}.}

\item{weights}{An object of class \link[=causalWeights-class]{causalWeights}.}

\item{...}{Not used at this time.}
}
\value{
A vector of mean balances
}
\description{
This function will calculate the difference in means between treatment groups standardized by the pooled standard-deviation of the respective covariates.
}
\examples{
n <- 100
p <- 6
x <- matrix(stats::rnorm(n * p), n, p)
z <- stats::rbinom(n, 1, 0.5)
weights <- calc_weight(x = x, z = z, estimand = "ATT", method = "Logistic")
mb <- mean_balance(x = x, z = z, weights = weights)
print(mb)
}
