% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateRespondents.R
\name{simulateRespondents}
\alias{simulateRespondents}
\alias{simulateRespondents,Cat-method}
\title{Simulate answer profiles given some true value of theta}
\usage{
\S4method{simulateRespondents}{Cat}(catObj, theta, n)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{theta}{A numeric representing the true position on the latent trait.}

\item{n}{A numeric indicating the number of answer profiles to simulate.}
}
\value{
Function returns a dataframe where each row is a possible answer profile simulated given the provided value of theta
}
\description{
The function simulates \code{n} answer profiles given a true value of theta and a battery's item parameters stored in a \code{Cat} object.
}
\examples{

# Load Cat object
data(grm_cat)

# Simulate 5 response profiles given a theta of 2
sim_resp <- simulateRespondents(catObj = grm_cat, theta = 2, n = 5)


}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
