% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor-constructor.R
\name{cosinor_reg}
\alias{cosinor_reg}
\alias{update.cosinor_reg}
\alias{print.cosinor_reg}
\title{General Interface for Cosinor Regression Models}
\usage{
cosinor_reg(mode = "regression", period = NULL)

\method{update}{cosinor_reg}(object, period = NULL, fresh = FALSE, ...)

\method{print}{cosinor_reg}(x, ...)
}
\arguments{
\item{mode}{A character string that describes the type of model. In this case, it only supports type of "regression".}

\item{period}{A non-negative number or vector of numbers that represent the expected periodicity of the data to be analyzed.}

\item{object}{Cosinor model specification}

\item{fresh}{A logical for whether the arguments should be modified in place or replaced altogether}

\item{...}{Extensible}

\item{x}{Cosinor model specification}
}
\description{
\code{cosinor_reg()} is a \emph{parsnip} friendly method for specification of cosinor regression model before fitting.
}
\examples{
library(parsnip)
cosinor_reg(period = c(24, 8)) |>
	parsnip::set_engine("card") |>
	parsnip::set_mode("regression")
}
