% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{collapseEntry}
\alias{collapseEntry}
\title{Create a collapsible container panel item}
\usage{
collapseEntry(
  ...,
  title,
  collapsed = FALSE,
  color.off = "darken",
  color.on = "red"
)
}
\arguments{
\item{...}{content of the collapsible container}

\item{title}{title of the collapsible container}

\item{collapsed}{whether the panel is collapsed or not}

\item{color.off}{color of collapsible icon when hover off}

\item{color.on}{color of collapsible icon when hover on}
}
\value{
An list containing the title and content of a collapsible container
}
\description{
Create a collapsible container panel item that is enclosed by a list
}
\details{
Get color choices using quickcode:::color.choice
}
\examples{
if (interactive()) {
 library(shiny)
 library(card.pro)
 card.pro(
  title = "Sample collapsible",width = 4,
  collapsibleGroup = list(
    collapseEntry(title = "Summary 1", collapsed = TRUE, "Convallis aesus."),
    collapseEntry(title = "Summary 2", "eiusmod tempor incididunt")
  )
)
}

}
