% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islamic.R
\name{islamic_new_year}
\alias{islamic_new_year}
\alias{mawlid}
\alias{ramadan}
\alias{eid_al_fitr}
\alias{eid_al_adha}
\title{Islamic holidays}
\usage{
islamic_new_year(year)

mawlid(year)

ramadan(year)

eid_al_fitr(year)

eid_al_adha(year)
}
\arguments{
\item{year}{A numeric vector of Gregorian years}
}
\value{
A vector of dates on the Gregorian calendar
}
\description{
Functions to return Gregorian dates for various Islamic holidays. Specific
dates can vary slightly based on moon sightings in different regions.
}
\examples{
tibble::tibble(
  year = 2025:2029,
  `New year` = islamic_new_year(year),
  Mawlid = mawlid(year),
  Ramadan = ramadan(year),
  `Eid al-Fitr` = eid_al_fitr(year),
  `Eid al-Adha` = eid_al_adha(year)
)
ramadan(2030)
}
\seealso{
\link{islamic_date}
}
