% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modern_hindu.R
\name{hindu_lunar_new_year}
\alias{hindu_lunar_new_year}
\alias{mesha_sankranti}
\alias{diwali}
\alias{shiva}
\alias{rama}
\alias{sacred_wednesdays}
\title{Hindu holidays and special days}
\usage{
hindu_lunar_new_year(year)

mesha_sankranti(year)

diwali(year)

shiva(year)

rama(year)

sacred_wednesdays(year)
}
\arguments{
\item{year}{A numeric vector of Gregorian years}
}
\value{
A vector of dates on the Gregorian calendar
}
\description{
Functions to return Gregorian dates for various Hindu holidays based on the
Hindu calendars.
Hindu Lunar New Year is the first day of the lunar month of Caitra (month 1).
The Birthday of Rama is on the 8th or 9th day of the first month (Caitra).
Diwali is on the new moon day in the month of Kartik (month 8).
The Great Night of Shiva is at the end of the 11 month of Magha.
Mesha Sankranti is the day when the sun enters the sign of Aries (Mesha).
Sacred Wednesdays are the 8th day of the lunar month that falls on a Wednesday.
Dates may vary by a day or two due to variations of the lunar calendar and local traditions.
}
\examples{
shiva(2025:2026)
hindu_lunar_new_year(2025:2026)
rama(2025:2026)
mesha_sankranti(2025:2026)
diwali(2025:2026)
sacred_wednesdays(2025:2026)
}
\seealso{
\link{hindu_lunar_date}
}
