% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCplotFuns.R
\name{qc_density_plot}
\alias{qc_density_plot}
\title{Create a density plot of log2 expression across samples of an experiment}
\usage{
qc_density_plot(expression.matrix, metadata, annotation.id)
}
\arguments{
\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression; a list  (of the same
length as modality) can be provided if #' \code{length(modality) > 1}}

\item{annotation.id}{name of metadata column on which to group samples}
}
\value{
The density plot as a ggplot object.
}
\description{
This function creates a density plot between all samples in the
expression matrix. Metadata columns are used to group samples.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

metadata <- data.frame(
  srr = colnames(expression.matrix.preproc), 
  timepoint = rep(c("0h", "12h", "36h"), each = 2)
)
print(qc_density_plot(expression.matrix.preproc, metadata, 'timepoint'))

}
