% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_conditional_effects.R
\name{plot_conditional_effects.bgmfit}
\alias{plot_conditional_effects.bgmfit}
\alias{plot_conditional_effects}
\title{Visualize conditional effects of predictor}
\usage{
\method{plot_conditional_effects}{bgmfit}(
  model,
  effects = NULL,
  conditions = NULL,
  int_conditions = NULL,
  re_formula = NA,
  spaghetti = FALSE,
  surface = FALSE,
  categorical = FALSE,
  ordinal = FALSE,
  method = "posterior_epred",
  transform = NULL,
  resolution = 100,
  select_points = 0,
  too_far = 0,
  prob = 0.95,
  robust = TRUE,
  newdata = NULL,
  ndraws = NULL,
  dpar = NULL,
  draw_ids = NULL,
  levels_id = NULL,
  resp = NULL,
  ipts = 10,
  deriv = 0,
  deriv_model = NULL,
  idata_method = NULL,
  verbose = FALSE,
  dummy_to_factor = NULL,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  funlist = NULL,
  envir = NULL,
  ...
)

plot_conditional_effects(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{effects}{An optional character vector naming effects (main effects or
interactions) for which to compute conditional plots. Interactions are
specified by a \code{:} between variable names. If \code{NULL} (the
default), plots are generated for all main effects and two-way interactions
estimated in the model. When specifying \code{effects} manually, \emph{all}
two-way interactions (including grouping variables) may be plotted
even if not originally modeled.}

\item{conditions}{An optional \code{data.frame} containing variable values
to condition on. Each effect defined in \code{effects} will
be plotted separately for each row of \code{conditions}. Values in the
\code{cond__} column will be used as titles of the subplots. If \code{cond__}
is not given, the row names will be used for this purpose instead.
It is recommended to only define a few rows in order to keep the plots clear.
See \code{\link[brms]{make_conditions}} for an easy way to define conditions.
If \code{NULL} (the default), numeric variables will be conditionalized by
using their means and factors will get their first level assigned.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{int_conditions}{An optional named \code{list} whose elements are
vectors of values of the variables specified in \code{effects}.
At these values, predictions are evaluated. The names of
\code{int_conditions} have to match the variable names exactly.
Additionally, the elements of the vectors may be named themselves,
in which case their names appear as labels for the conditions in the plots.
Instead of vectors, functions returning vectors may be passed and are
applied on the original values of the corresponding variable.
If \code{NULL} (the default), predictions are evaluated at the
\eqn{mean} and at \eqn{mean +/- sd} for numeric predictors and at
all categories for factor-like predictors.}

\item{re_formula}{A formula containing group-level effects to be considered
in the conditional predictions. If \code{NULL}, include all group-level
effects; if \code{NA} (default), include no group-level effects.}

\item{spaghetti}{Logical. Indicates if predictions should
be visualized via spaghetti plots. Only applied for numeric
predictors. If \code{TRUE}, it is recommended
to set argument \code{ndraws} to a relatively small value
(e.g., \code{100}) in order to reduce computation time.}

\item{surface}{Logical. Indicates if interactions or
two-dimensional smooths should be visualized as a surface.
Defaults to \code{FALSE}. The surface type can be controlled
via argument \code{stype} of the related plotting method.}

\item{categorical}{Logical. Indicates if effects of categorical
or ordinal models should be shown in terms of probabilities
of response categories. Defaults to \code{FALSE}.}

\item{ordinal}{(Deprecated) Please use argument \code{categorical}.
Logical. Indicates if effects in ordinal models
should be visualized as a raster with the response categories
on the y-axis. Defaults to \code{FALSE}.}

\item{method}{Method used to obtain predictions. Can be set to
\code{"posterior_epred"} (the default), \code{"posterior_predict"},
or \code{"posterior_linpred"}. For more details, see the respective
function documentations.}

\item{transform}{A function or a character string naming
a function to be applied on the predicted responses
before summary statistics are computed. Only allowed
if \code{method = "posterior_predict"}.}

\item{resolution}{Number of support points used to generate
the plots. Higher resolution leads to smoother plots.
Defaults to \code{100}. If \code{surface} is \code{TRUE},
this implies \code{10000} support points for interaction terms,
so it might be necessary to reduce \code{resolution}
when only few RAM is available.}

\item{select_points}{Positive number.
Only relevant if \code{points} or \code{rug} are set to \code{TRUE}:
Actual data points of numeric variables that
are too far away from the values specified in \code{conditions}
can be excluded from the plot. Values are scaled into
the unit interval and then points more than \code{select_points}
from the values in \code{conditions} are excluded.
By default, all points are used.}

\item{too_far}{Positive number.
For surface plots only: Grid points that are too
far away from the actual data points can be excluded from the plot.
\code{too_far} determines what is too far. The grid is scaled into
the unit square and then grid points more than \code{too_far}
from the predictor variables are excluded. By default, all
grid points are used. Ignored for non-surface plots.}

\item{prob}{A value between 0 and 1 indicating the desired probability
to be covered by the uncertainty intervals. The default is 0.95.}

\item{robust}{If \code{TRUE} (the default) the median is used as the
measure of central tendency. If \code{FALSE} the mean is used instead.}

\item{newdata}{An optional data frame for estimation. If \code{NULL}
(default), \code{newdata} is retrieved from the \code{model}.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
use in estimation. If \code{NULL} (default), all draws are used.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{draw_ids}{An integer specifying the specific posterior draw(s) to use
in estimation (default \code{NULL}).}

\item{levels_id}{An optional argument to specify the \code{ids} for the
hierarchical model (default \code{NULL}). It is used only when the model is
applied to data with three or more levels of hierarchy. For a two-level
model, \code{levels_id} is automatically inferred from the model fit. For
models with three or more levels, \code{levels_id} is inferred from the
model fit under the assumption that hierarchy is specified from the lowest
to the uppermost level, i.e., \code{id} followed by \code{study}, where
\code{id} is nested within \code{study}. However, it is not guaranteed that
\code{levels_id} is sorted correctly, so it is better to set it manually
when fitting a model with three or more levels of hierarchy.}

\item{resp}{A character string (default \code{NULL}) to specify the response
variable when processing posterior draws for \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models.}

\item{ipts}{An integer to set the length of the predictor variable for
generating a smooth velocity curve. If \code{NULL}, the original values are
returned. If an integer (e.g., \code{ipts = 10}, default), the predictor is
interpolated. Note that these interpolations do not alter the range of the
predictor when calculating population averages and/or individual-specific
growth curves.}

\item{deriv}{An integer indicating whether to estimate the distance curve
or its derivative (velocity curve). The default \code{deriv = 0} is for
the distance curve, while \code{deriv = 1} is for the velocity curve.}

\item{deriv_model}{A logical value specifying whether to estimate the
velocity curve from the derivative function or by differentiating the
distance curve. Set \code{deriv_model = TRUE} for functions that require
the velocity curve, such as \code{growthparameters()} and
\code{plot_curves()}. Set it to \code{NULL} for functions that use the
distance curve (i.e., fitted values), such as \code{loo_validation()} and
\code{plot_ppc()}.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of interpolation points is set by the \code{ipts} argument.
Available options for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}).
\itemize{
\item \emph{Method 1} (\code{'m1'}) is adapted from the \pkg{iapvbs} package
and is documented
\href{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}{here}.
\item \emph{Method 2} (\code{'m2'}) is based on the \pkg{JMbayes} package
and is documented
\href{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}{here}.
The \code{'m1'} method works by internally constructing the data frame
based on the model configuration, while the \code{'m2'} method uses the
exact data frame from the model fit, accessible via \code{fit$data}. If
\code{idata_method = NULL} (default), method \code{'m2'} is automatically
selected. Note that method \code{'m1'} may fail in certain cases,
especially when the model includes covariates (particularly in
\code{univariate_by} models). In such cases, it is recommended to use
method \code{'m2'}.
}}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{dummy_to_factor}{A named list (default \code{NULL}) to convert dummy
variables into a factor variable. The list must include the following
elements:
\itemize{
\item \code{factor.dummy}: A character vector of dummy variables to be
converted to factors.
\item \code{factor.name}: The name for the newly created factor variable
(default is \code{'factor.var'} if \code{NULL}).
\item \code{factor.level}: A vector specifying the factor levels.
If \code{NULL}, levels are taken from \code{factor.dummy}.
If \code{factor.level} is provided, its length must match
\code{factor.dummy}.
}}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{usesavedfuns}{A logical value (default \code{NULL}) indicating whether
to use already exposed and saved Stan functions. This is typically set
automatically based on the \code{expose_functions} argument from the
\code{\link[=bsitar]{bsitar()}} call. Manual specification of \code{usesavedfuns} is rarely
needed and is intended for internal testing, as improper use can lead to
unreliable estimates.}

\item{clearenvfuns}{A logical value indicating whether to clear the exposed
Stan functions from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL}, \code{clearenvfuns} is set based on the value of
\code{usesavedfuns}: \code{TRUE} if \code{usesavedfuns = TRUE}, or
\code{FALSE} if \code{usesavedfuns = FALSE}.}

\item{funlist}{A list (default \code{NULL}) specifying function names. This
is rarely needed, as required functions are typically retrieved
automatically. A use case for \code{funlist} is when \code{sigma_formula},
\code{sigma_formula_gr}, or \code{sigma_formula_gr_str} use an external
function (e.g., \code{poly(age)}). The \code{funlist} should include
function names defined in the \code{globalenv()}. For functions needing
both distance and velocity curves (e.g., \code{plot_curves(..., opt =
  'dv')}), \code{funlist} must include two functions: one for the distance
curve and one for the velocity curve.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}
function. Please see \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} for details.}
}
\value{
An object of class \code{'brms_conditional_effects'}, which is a
named list with one data.frame per effect containing all information
required to generate conditional effects plots. See
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} for details.
}
\description{
Display conditional effects of one or more numeric and/or categorical
predictors including two-way interaction effects.
}
\details{
The \strong{plot_conditional_effects()} is a wrapper around the
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}. The \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} function
from the \pkg{brms} package can be used to plot the fitted (distance) curve
when response (e.g., height) is not transformed. However, when the outcome
is log or square root transformed, the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} will
return the fitted curve on the log or square root scale, whereas the
\strong{plot_conditional_effects()} will return the fitted curve on the
original scale. Furthermore, the \strong{plot_conditional_effects()} also
plots the velocity curve on the original scale after making the required
back-transformation. Apart from these differences, both these functions
(\link[brms:conditional_effects.brmsfit]{brms::conditional_effects} and \strong{plot_conditional_effects()}) work
in the same manner. In other words, the user can specify all the arguments
which are available in the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Population average distance curve
plot_conditional_effects(model, deriv = 0, re_formula = NA)

# Individual-specific distance curves
plot_conditional_effects(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
plot_conditional_effects(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
plot_conditional_effects(model, deriv = 1, re_formula = NULL)
}

}
\seealso{
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
