% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_validation.R
\name{loo_validation.bgmfit}
\alias{loo_validation.bgmfit}
\alias{loo_validation}
\title{Perform leave-one-out (LOO) cross-validation}
\usage{
\method{loo_validation}{bgmfit}(
  model,
  compare = TRUE,
  resp = NULL,
  dpar = NULL,
  pointwise = FALSE,
  moment_match = FALSE,
  reloo = FALSE,
  k_threshold = 0.7,
  save_psis = FALSE,
  moment_match_args = list(),
  reloo_args = list(),
  model_names = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  cores = 1,
  deriv_model = NULL,
  verbose = FALSE,
  dummy_to_factor = NULL,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

loo_validation(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{compare}{A logical flag indicating if the information criteria of the
models should be compared using \code{\link[loo:loo_compare]{loo::loo_compare()}}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation.
The latter approach is usually considerably slower but
requires much less working memory. Accordingly, if one runs
into memory issues, \code{pointwise = TRUE} is the way to go.}

\item{moment_match}{A logical flag to indicate whether
\code{\link[loo:loo_moment_match]{loo::loo_moment_match()}} should be applied to problematic observations.
Defaults to \code{FALSE}. For most models, moment matching will only work
if \code{save_pars = save_pars(all = TRUE)} was set when fitting the model
with \code{\link[brms:brm]{brms::brm()}}. See \code{\link[brms:loo_moment_match.brmsfit]{brms::loo_moment_match()}} for more details.}

\item{reloo}{A logical flag indicating whether \code{\link[brms:reloo.brmsfit]{brms::reloo()}} should be
applied to problematic observations. Defaults to \code{FALSE}.}

\item{k_threshold}{The Pareto \eqn{k} threshold for which observations
\code{\link[brms]{loo_moment_match}} or \code{\link[brms]{reloo}} is applied if
argument \code{moment_match} or \code{reloo} is \code{TRUE}.
Defaults to \code{0.7}.
See \code{\link[loo:pareto-k-diagnostic]{pareto_k_ids}} for more details.}

\item{save_psis}{Should the \code{"psis"} object created internally be saved
in the returned object? For more details see \code{\link[loo:loo]{loo}}.}

\item{moment_match_args}{An optional \code{list} of additional arguments
passed to \code{\link[loo:loo_moment_match]{loo::loo_moment_match()}}.}

\item{reloo_args}{An optional \code{list} of additional arguments passed to
\code{\link[brms:reloo.brmsfit]{brms::reloo()}}.}

\item{model_names}{If \code{NULL} (the default) will use model names
derived from deparsing the call. Otherwise will use the passed
values as model names.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
use in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer specifying the specific posterior draw(s) to use
in estimation (default \code{NULL}).}

\item{cores}{The number of cores to be used for parallel computations if
\code{future = TRUE}. On non-Windows systems, this argument can be set
globally via the \code{mc.cores} option. By default, \code{NULL}, the
number of cores is automatically determined using
\code{\link[future:re-exports]{future::availableCores()}}, and it will use the maximum number of cores
available minus one (i.e., \code{future::availableCores() - 1}).}

\item{deriv_model}{A logical value specifying whether to estimate the
velocity curve from the derivative function or by differentiating the
distance curve. Set \code{deriv_model = TRUE} for functions that require
the velocity curve, such as \code{growthparameters()} and
\code{plot_curves()}. Set it to \code{NULL} for functions that use the
distance curve (i.e., fitted values), such as \code{loo_validation()} and
\code{plot_ppc()}.}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{dummy_to_factor}{A named list (default \code{NULL}) to convert dummy
variables into a factor variable. The list must include the following
elements:
\itemize{
\item \code{factor.dummy}: A character vector of dummy variables to be
converted to factors.
\item \code{factor.name}: The name for the newly created factor variable
(default is \code{'factor.var'} if \code{NULL}).
\item \code{factor.level}: A vector specifying the factor levels.
If \code{NULL}, levels are taken from \code{factor.dummy}.
If \code{factor.level} is provided, its length must match
\code{factor.dummy}.
}}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{usesavedfuns}{A logical value (default \code{NULL}) indicating whether
to use already exposed and saved Stan functions. This is typically set
automatically based on the \code{expose_functions} argument from the
\code{\link[=bsitar]{bsitar()}} call. Manual specification of \code{usesavedfuns} is rarely
needed and is intended for internal testing, as improper use can lead to
unreliable estimates.}

\item{clearenvfuns}{A logical value indicating whether to clear the exposed
Stan functions from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL}, \code{clearenvfuns} is set based on the value of
\code{usesavedfuns}: \code{TRUE} if \code{usesavedfuns = TRUE}, or
\code{FALSE} if \code{usesavedfuns = FALSE}.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the \code{\link[brms:loo.brmsfit]{brms::loo()}} function.
Please see \code{brms::loo} for details on various options available.}
}
\value{
If only one model object is provided, an object of class \code{loo}
is returned. If multiple objects are provided, an object of class
\code{loolist} is returned.
}
\description{
The \strong{loo_validation()} function is a wrapper around the
\code{\link[brms:loo.brmsfit]{brms::loo()}} function to perform approximate leave-one-out cross-validation
based on the posterior likelihood. See \code{\link[brms:loo.brmsfit]{brms::loo()}} for more details.
}
\details{
The function supports model comparisons using \code{\link[loo:loo_compare]{loo::loo_compare()}}
for comparing information criteria across models. For \code{bgmfit}
objects, \code{LOO} is simply an alias for \code{loo}. Additionally, you
can use \code{\link[brms:add_criterion]{brms::add_criterion()}} to store information criteria in the fitted
model object for later use.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Perform leave-one-out cross-validation
loo_validation(model, cores = 1)
}

}
\seealso{
\code{\link[brms:loo.brmsfit]{brms::loo()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
