% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-RNA_halflife_R2_selection.R
\name{BridgeRHalfLifeCalcR2Select}
\alias{BridgeRHalfLifeCalcR2Select}
\title{Calculate RNA half-life for each gene using R2 selection method.}
\usage{
BridgeRHalfLifeCalcR2Select(inputFile, group = c("Control", "Knockdown"),
  hour = c(0, 1, 2, 4, 8, 12), inforColumn = 4, CutoffTimePointNumber = 4,
  R2_criteria = 0.9, TimePointRemoval1 = c(1, 2), TimePointRemoval2 = c(8,
  12), ThresholdHalfLife1 = 3, ThresholdHalfLife2 = 12, save = T,
  outputPrefix = "BridgeR_5")
}
\arguments{
\item{inputFile}{The vector of tab-delimited matrix file.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{inforColumn}{The number of information columns.}

\item{CutoffTimePointNumber}{The number of minimum time points for calc.}

\item{R2_criteria}{The cutoff of R2 for R2 selection.}

\item{TimePointRemoval1}{The candicate_1 of time point removal.}

\item{TimePointRemoval2}{The candicate_2 of time point removal.}

\item{ThresholdHalfLife1}{The cutoff of TimePointRemoval1.}

\item{ThresholdHalfLife2}{The cutoff of TimePointRemoval2.}

\item{save}{Whether to save the output matrix file.}

\item{outputPrefix}{The prefix for the name of the output.}
}
\value{
data.table object about RNA half-life, R2 and fitting model.
}
\description{
\code{BridgeRHalfLifeCalcR2Select} calculates RNA half-life for each gene
using R2 selection method (default version).
}
\examples{
library(data.table)
normalized_rpkm_matrix <- data.table(gr_id = c(8, 9, 14),
                                     symbol = c("AAAS", "AACS", "AADAT"),
                                     accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                                     locus = c("chr12", "chr12", "chr4"),
                                     CTRL_1_0h = c(1.00, 1.00, 1.00),
                                     CTRL_1_1h = c(1.00, 0.86, 0.96),
                                     CTRL_1_2h = c(1.00, 0.96, 0.88),
                                     CTRL_1_4h = c(1.00, 0.74, 0.85),
                                     CTRL_1_8h = c(1.00, 0.86, 0.68),
                                     CTRL_1_12h = c(1.01, 0.65, 0.60),
                                     gr_id = c(8, 9, 14),
                                     symbol = c("AAAS", "AACS", "AADAT"),
                                     accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                                     locus = c("chr12", "chr12", "chr4"),
                                     KD_1_0h = c(1.00, 1.00, 1.00),
                                     KD_1_1h = c(1.01, 0.73, 0.71),
                                     KD_1_2h = c(1.01, 0.77, 0.69),
                                     KD_1_4h = c(1.01, 0.72, 0.67),
                                     KD_1_8h = c(1.01, 0.64, 0.38),
                                     KD_1_12h = c(1.00, 0.89, 0.63))
group <- c("Control", "Knockdown")
hour <- c(0, 1, 2, 4, 8, 12)
halflife_table <- BridgeRHalfLifeCalcR2Select(normalized_rpkm_matrix,
                                              group = group,
                                              hour = hour,
                                              save = FALSE)

}

