% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_stats.R
\name{GLM model selection}
\alias{GLM model selection}
\alias{logLik.bg_GLM}
\alias{extractAIC.bg_GLM}
\title{Model selection for bg_GLM objects}
\usage{
\method{logLik}{bg_GLM}(object, REML = FALSE, ...)

\method{extractAIC}{bg_GLM}(fit, scale = 0, k = 2, ...)
}
\arguments{
\item{object, fit}{A \code{bg_GLM} object}

\item{REML}{Logical indicating whether to return the \emph{restricted}
log-likelihood. Default: \code{FALSE}}

\item{...}{Unused}

\item{scale}{Should be left at its default}

\item{k}{Numeric; the weight of the equivalent degrees of freedom}
}
\value{
\code{logLik} returns an object of class \code{logLik} with several
  attributes. \code{extractAIC} returns a numeric vector in which the first
  element is the \emph{equivalent degrees of freedom} and the remaining are
  the AIC's for each region
}
\description{
These functions compute the log-likelihood and Akaike's \emph{An Information
Criterion (AIC)} of a \code{bg_GLM} object. See
\code{\link[stats]{logLik.lm}} and \code{\link[stats]{extractAIC}} for
details.
}
\details{
The functions \code{\link[stats]{AIC}} and \code{\link[stats]{BIC}} will also
work for \code{bg_GLM} objects because they each call \code{logLik}.
}
