% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_distribution.R
\name{gamma_distribution}
\alias{gamma_distribution}
\alias{gamma_pdf}
\alias{gamma_lpdf}
\alias{gamma_cdf}
\alias{gamma_lcdf}
\alias{gamma_quantile}
\title{Gamma Distribution Functions}
\usage{
gamma_distribution(shape, scale = 1)

gamma_pdf(x, shape, scale = 1)

gamma_lpdf(x, shape, scale = 1)

gamma_cdf(x, shape, scale = 1)

gamma_lcdf(x, shape, scale = 1)

gamma_quantile(p, shape, scale = 1)
}
\arguments{
\item{shape}{shape parameter (shape > 0)}

\item{scale}{scale parameter (scale > 0)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Gamma distribution.
}
\examples{
# Gamma distribution with shape = 3, scale = 4
dist <- gamma_distribution(3, 4)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
gamma_pdf(2, 3, 4)
gamma_lpdf(2, 3, 4)
gamma_cdf(2, 3, 4)
gamma_lcdf(2, 3, 4)
gamma_quantile(0.5, 3, 4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/gamma_dist.html}{Boost Documentation} for more details on the mathematical background.
}
